/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages;

import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.config.AllConfigs;
import toni.immersivemessages.renderers.CaxtonRenderer;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.renderers.VanillaRenderer;
import toni.lib.utils.PlatformUtils;

public class ImmersiveMessagesManager {
    private static final Queue<ImmersiveMessage> tooltipQueue = new LinkedList<ImmersiveMessage>();
    private static final ITooltipRenderer renderer = ImmersiveMessagesManager.initRenderer();
    private static final ITooltipRenderer vanillaRenderer = new VanillaRenderer();
    private static final float NANOSECONDS_PER_TICK = 5.0E7f;
    private static long lastTime = System.nanoTime();
    private static ImmersiveMessage currentTooltip;
    private static double countdownToNextTooltip;
    public static boolean forceVanillaRenderer;

    public static ITooltipRenderer getRenderer() {
        if (forceVanillaRenderer) {
            return vanillaRenderer;
        }
        return renderer;
    }

    static void render(class_332 graphics, class_9779 delta) {
        long currentTime = System.nanoTime();
        if (class_310.method_1551().method_1493()) {
            lastTime = currentTime;
            return;
        }
        float partialTicks = delta.method_60638();
        countdownToNextTooltip -= (double)partialTicks;
        if (currentTooltip == null) {
            if (tooltipQueue.isEmpty()) {
                return;
            }
            currentTooltip = tooltipQueue.remove();
        }
        if (countdownToNextTooltip > 0.0) {
            return;
        }
        ImmersiveMessagesManager.renderTooltip(graphics, partialTicks, currentTooltip, 0);
    }

    static void renderTooltip(class_332 graphics, float deltaTicks, ImmersiveMessage tooltip, int depth) {
        tooltip.tick(deltaTicks);
        tooltip.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth == 0 && tooltip.animation.getCurrent() >= tooltip.animation.duration) {
            currentTooltip = null;
            countdownToNextTooltip = 20.0 * (Double)AllConfigs.client().timeBetweenMessages.get();
            return;
        }
        renderer.render(tooltip, graphics, deltaTicks);
        if (tooltip.subtext != null) {
            ImmersiveMessagesManager.renderTooltip(graphics, deltaTicks, tooltip.subtext, depth + 1);
        }
    }

    private static ITooltipRenderer initRenderer() {
        if (PlatformUtils.isModLoaded((String)"caxton")) {
            return new CaxtonRenderer();
        }
        return new VanillaRenderer();
    }

    static void showToPlayer(class_746 player, ImmersiveMessage tooltip) {
        tooltipQueue.add(tooltip);
    }

    public static boolean hasTooltip() {
        return currentTooltip != null;
    }

    public static int queueCount() {
        return tooltipQueue.size();
    }

    static {
        countdownToNextTooltip = 0.0;
        forceVanillaRenderer = false;
    }
}

